import { register } from "@minecraft/server-gametest";
import { system, Vector } from "@minecraft/server";

const down = { x: 0, y: -1, z: 0 };

function highFriction(test) {
    const vanilla = test.spawnSimulatedPlayer({ x: 3, y: 2, z: 1 }, "Vanilla Block");
    vanilla.moveToBlock({ x: 3, y: 2, z: 9 });
    const custom = test.spawnSimulatedPlayer({ x: 1, y: 2, z: 1 }, "Custom Block");
    custom.moveToBlock({ x: 1, y: 2, z: 9 });
    const dim = test.getDimension();

    let vanillaEnd = 0;
    let customEnd = 0;
    test.succeedWhen(() => {
        if (!vanillaEnd && dim.getBlock(Vector.add(vanilla.location, down)).typeId === "minecraft:diamond_block") {
            vanillaEnd = system.currentTick;
        }
        if (!customEnd && dim.getBlock(Vector.add(custom.location, down)).typeId === "minecraft:diamond_block") {
            customEnd = system.currentTick;
        }
        test.assert(!!vanillaEnd && !!customEnd, "Race in progress...");

        if (Math.abs(vanillaEnd - customEnd) > 20) {
            test.fail("Custom block not slowing down player as expected!");
        }
    })
};

// Registration Code for our test
register("bugreport", "highfriction", highFriction).maxTicks(410).structureName("rouje:high_friction");